<?php

defined( 'ABSPATH' ) or exit;

// Visible but disabled
isset( $add_countdown ) or $add_countdown = false;

if ( bulletinwp_fs()->is__premium_only() ) {
  // Actual hidden on premium
  isset( $countdown ) or $countdown                                   = '';
  isset( $show_countdown ) or $show_countdown                         = false;
  isset( $countdown_background_color ) or $countdown_background_color = '';
  isset( $countdown_font_color ) or $countdown_font_color             = '';
  isset( $countdown_enable_labels ) or $countdown_enable_labels       = true;
  isset( $countdown_font_size_desktop ) or $countdown_font_size_desktop = '16';
  isset( $countdown_font_size_mobile ) or $countdown_font_size_mobile   = '16';
  isset( $countdown_enable_semicolon ) or $countdown_enable_semicolon = true;
  $countdown_enable_labels       = wp_validate_boolean( $countdown_enable_labels );
  $countdown_font_size_desktop   = ! empty( $countdown_font_size_desktop ) ? $countdown_font_size_desktop : '16';
  $countdown_font_size_mobile    = ! empty( $countdown_font_size_mobile ) ? $countdown_font_size_mobile : '16';
  $countdown_enable_semicolon    = wp_validate_boolean( $countdown_enable_semicolon );
  isset( $countdown_alignment ) or $countdown_alignment               = 'left';
  isset( $countdown_days_label ) or $countdown_days_label             = '';
  isset( $countdown_hours_label ) or $countdown_hours_label           = '';
  isset( $countdown_mins_label ) or $countdown_mins_label             = '';
  isset( $countdown_secs_label ) or $countdown_secs_label             = '';
  $countdown_alignment = ! empty( $countdown_alignment ) ? $countdown_alignment : 'left';
}

// Images directory
$images_dir = plugin_dir_url( BULLETINWP__FILE__ ) . 'admin/images';

?>

<!-- TAB - Expiry -->
<div id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-expiry-tab' ) ?>" class="tab-pane">
    <div class="flex items-center mb-8 md:mb-12">
        <div class="heading-icon mr-4">
            <img src="<?php echo esc_url( $images_dir . '/tab-icon/message.svg' ) ?>" alt="">
        </div>

        <div class="tab-heading">
            <?php esc_html_e( 'Expiry', 'bulletinwp' ) ?>
        </div>
    </div>

    <div class="heading flex items-center">
        <?php esc_html_e( 'Expire bulletin', 'bulletinwp' ) ?>

        <?php if ( bulletinwp_fs()->is__premium_only() ) :
        else :?>
        <div class="pro-pill">PRO</div>
        <?php endif; ?>
    </div>

    <hr class="my-4">

    <div class="checkbox-wrapper toggle-switch add-countdown-data-label <?php echo esc_attr( bulletinwp_fs()->is__premium_only() ? '' : 'pro-disabled' ) ?>"
            data-checked-label="<?php echo esc_attr( esc_html__( 'Yes', 'bulletinwp' ) ) ?>"
            data-unchecked-label="<?php echo esc_attr( esc_html__( 'No', 'bulletinwp' ) ) ?>"
            data-hide-show-elements="<?php echo esc_attr( '#' . BULLETINWP_PLUGIN_SLUG . '-countdown-element' ) ?>"
    >
        <input type="checkbox" name="addCountdown" <?php checked( $add_countdown ) ?> />
        <span class="label add-countdown-label"><?php echo esc_html( $add_countdown ? esc_html__( 'Yes', 'bulletinwp' ) : esc_html__( 'No', 'bulletinwp' ) ) ?></span>
    </div>

    <?php if ( bulletinwp_fs()->is__premium_only() ) : ?>
        <div id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-countdown-element' ) ?>"
            style="display: <?php echo esc_attr( $add_countdown ? 'block' : 'none' ) ?>"
        >
            <div class="form-field form-field-text is-required mt-4">
                <label for="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-countdown' ) ?>"><?php esc_html_e( 'Expiry date/time', 'bulletinwp' ) ?></label>
                <div id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-note-schedule' ) ?>">
                <i><?php esc_html_e( 'Note: Bulletin will not show after this time and will be set to inactive' ) ?></i>
                </div>
                <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-countdown' ) ?>"
                        class="form-input w-full date-time-picker-input"
                        type="text"
                        name="countdown"
                        value="<?php echo esc_attr( $countdown ) ?>"
                        placeholder=""
                        autocomplete="off"
                />
            </div>

            <div class="heading mt-8"><?php esc_html_e( 'Show countdown', 'bulletinwp' ) ?></div>

            <hr class="my-4">

            <div class="checkbox-wrapper toggle-switch"
                    data-checked-label="<?php esc_html_e( 'Yes', 'bulletinwp' ) ?>"
                    data-unchecked-label="<?php esc_html_e( 'No', 'bulletinwp' ) ?>"
                    data-hide-show-elements="<?php echo esc_attr( '#' . BULLETINWP_PLUGIN_SLUG . '-countdown-labels, #' . BULLETINWP_PLUGIN_SLUG . '-countdown-style, #' . BULLETINWP_PLUGIN_SLUG . '-countdown-styling' ) ?>"
            >
                <input type="checkbox" name="showCountdown" <?php checked( $show_countdown ) ?> />
                <span class="label"><?php echo esc_html( $show_countdown ? esc_html__( 'Yes', 'bulletinwp' ) : esc_html__( 'No', 'bulletinwp' ) ) ?></span>
            </div>

            <!-- Countdown BG / Font Color -->
            <div id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-countdown-style' ) ?>"
                    class="mt-4"
                    style="display: <?php echo esc_attr( $show_countdown ? 'block' : 'none' ) ?>"
            >
                <div class="flex flex-col md:flex-row mb-4">
                  <div class="form-field form-field-color-picker flex flex-col mr-0 md:mr-4 mb-4 md:mb-0 is-required">
                    <label for="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-countdown-background-color' ) ?>"><?php esc_html_e( 'Background color', 'bulletinwp' ) ?></label>
                    <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-countdown-background-color' ) ?>"
                            class="form-input color-picker-input"
                            type="text"
                            name="countdownBackgroundColor"
                            value="<?php echo esc_attr( $countdown_background_color ) ?>"
                            placeholder=""
                            data-default-color=""
                    />
                  </div>

                  <div class="form-field form-field-color-picker flex flex-col mr-0 md:mr-4 mb-4 is-required">
                    <label for="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-countdown-font-color' ) ?>"><?php esc_html_e( 'Font color', 'bulletinwp' ) ?></label>
                    <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-countdown-font-color' ) ?>"
                            class="form-input color-picker-input"
                            type="text"
                            name="countdownFontColor"
                            value="<?php echo esc_attr( $countdown_font_color ) ?>"
                            placeholder=""
                            data-default-color=""
                    />
                  </div>
                </div>
            </div>

            <!-- Countdown Override Labels -->
            <div id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-countdown-labels' ) ?>"
                    class="mt-8"
                    style="display: <?php echo esc_attr( $show_countdown ? 'block' : 'none' ) ?>"
            >

                <div class="heading"><?php esc_html_e( 'Override labels', 'bulletinwp' ) ?></div>

                <hr class="my-4">

                <div class="form-field mt-4">
                    <label class="block mb-2"><?php esc_html_e( 'Enable labels', 'bulletinwp' ) ?></label>
                    <div class="checkbox-wrapper toggle-switch"
                            data-checked-label="<?php echo esc_attr( esc_html__( 'Yes', 'bulletinwp' ) ) ?>"
                            data-unchecked-label="<?php echo esc_attr( esc_html__( 'No', 'bulletinwp' ) ) ?>"
                            data-hide-show-elements="<?php echo esc_attr( '#' . BULLETINWP_PLUGIN_SLUG . '-countdown-label-fields' ) ?>"
                    >
                        <input type="checkbox"
                               name="enableCountdownLabels"
                               <?php checked( $countdown_enable_labels ) ?>
                        />
                        <span class="label"><?php echo esc_html( $countdown_enable_labels ? esc_html__( 'Yes', 'bulletinwp' ) : esc_html__( 'No', 'bulletinwp' ) ) ?></span>
                    </div>
                </div>

                <div id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-countdown-label-fields' ) ?>"
                        class="flex flex-col md:flex-row mt-4"
                        style="display: <?php echo esc_attr( $countdown_enable_labels ? 'flex' : 'none' ) ?>"
                >
                    <div class="form-field flex flex-col mr-0 md:mr-4 mb-4 md:mb-0">
                        <label for="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-countdown-days-label' ) ?>"><?php esc_html_e( 'Days label', 'bulletinwp' ) ?></label>
                        <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-countdown-days-label' ) ?>"
                                class="form-input"
                                type="text"
                                name="countdownDaysLabel"
                                value="<?php echo esc_attr( $countdown_days_label ) ?>"
                                placeholder="<?php echo esc_attr( esc_html__( 'days', 'bulletinwp' ) ) ?>"
                        />
                    </div>

                    <div class="form-field flex flex-col mr-0 md:mr-4 mb-4 md:mb-0">
                        <label for="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-countdown-hours-label' ) ?>"><?php esc_html_e( 'Hours label', 'bulletinwp' ) ?></label>
                        <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-countdown-hours-label' ) ?>"
                                class="form-input"
                                type="text"
                                name="countdownHoursLabel"
                                value="<?php echo esc_attr( $countdown_hours_label ) ?>"
                                placeholder="<?php echo esc_attr( esc_html__( 'hours', 'bulletinwp' ) ) ?>"
                        />
                    </div>

                    <div class="form-field flex flex-col mr-0 md:mr-4 mb-4 md:mb-0">
                        <label for="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-countdown-mins-label' ) ?>"><?php esc_html_e( 'Minutes label', 'bulletinwp' ) ?></label>
                        <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-countdown-mins-label' ) ?>"
                                class="form-input"
                                type="text"
                                name="countdownMinsLabel"
                                value="<?php echo esc_attr( $countdown_mins_label ) ?>"
                                placeholder="<?php echo esc_attr( esc_html__( 'minutes', 'bulletinwp' ) ) ?>"
                        />
                    </div>

                    <div class="form-field flex flex-col mr-0 md:mr-4 mb-4 md:mb-0">
                        <label for="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-countdown-secs-label' ) ?>"><?php esc_html_e( 'Seconds label', 'bulletinwp' ) ?></label>
                        <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-countdown-secs-label' ) ?>"
                                class="form-input"
                                type="text"
                                name="countdownSecsLabel"
                                value="<?php echo esc_attr( $countdown_secs_label ) ?>"
                                placeholder="<?php echo esc_attr( esc_html__( 'seconds', 'bulletinwp' ) ) ?>"
                        />
                    </div>
                </div>
            </div>

            <!-- Countdown Styling -->
            <div id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-countdown-styling' ) ?>"
                    class="mt-8"
                    style="display: <?php echo esc_attr( $show_countdown ? 'block' : 'none' ) ?>"
            >
                <div class="heading"><?php esc_html_e( 'Countdown styling', 'bulletinwp' ) ?></div>

                <hr class="my-4">

                <div class="form-field mt-4">
                    <label class="block mb-2"><?php esc_html_e( 'Alignment on Desktop/Mobile', 'bulletinwp' ) ?></label>
                    <div class="radio-group-wrapper flex">
                        <div class="mr-4">
                            <label class="radio-wrapper">
                                <input type="radio"
                                       id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-countdown-alignment-left' ) ?>"
                                       name="countdownAlignment"
                                       value="left"
                                       <?php checked( $countdown_alignment, 'left' ) ?>
                                />
                                <span class="thumb"></span>
                                <span><?php esc_html_e( 'Left/Top', 'bulletinwp' ) ?></span>
                            </label>
                        </div>

                        <div>
                            <label class="radio-wrapper">
                                <input type="radio"
                                       id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-countdown-alignment-right' ) ?>"
                                       name="countdownAlignment"
                                       value="right"
                                       <?php checked( $countdown_alignment, 'right' ) ?>
                                />
                                <span class="thumb"></span>
                                <span><?php esc_html_e( 'Right/Bottom', 'bulletinwp' ) ?></span>
                            </label>
                        </div>
                    </div>
                </div>

                <div class="flex flex-col md:flex-row mt-4">
                    <div class="form-field flex flex-col mr-0 md:mr-4 mb-4 md:mb-0">
                        <label for="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-countdown-font-size-desktop' ) ?>"><?php esc_html_e( 'Desktop font-size (px)', 'bulletinwp' ) ?></label>
                        <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-countdown-font-size-desktop' ) ?>"
                                class="form-input"
                                type="number"
                                min="1"
                                name="countdownFontSizeDesktop"
                                value="<?php echo esc_attr( $countdown_font_size_desktop ) ?>"
                                placeholder="16"
                        />
                    </div>

                    <div class="form-field flex flex-col">
                        <label for="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-countdown-font-size-mobile' ) ?>"><?php esc_html_e( 'Mobile font-size (px)', 'bulletinwp' ) ?></label>
                        <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-countdown-font-size-mobile' ) ?>"
                                class="form-input"
                                type="number"
                                min="1"
                                name="countdownFontSizeMobile"
                                value="<?php echo esc_attr( $countdown_font_size_mobile ) ?>"
                                placeholder="16"
                        />
                    </div>
                </div>

                <div class="form-field mt-4">
                    <label class="block mb-2"><?php esc_html_e( 'Enable semicolons between numbers', 'bulletinwp' ) ?></label>
                    <div class="checkbox-wrapper toggle-switch"
                            data-checked-label="<?php echo esc_attr( esc_html__( 'Yes', 'bulletinwp' ) ) ?>"
                            data-unchecked-label="<?php echo esc_attr( esc_html__( 'No', 'bulletinwp' ) ) ?>"
                    >
                        <input type="checkbox"
                               name="enableCountdownSemicolon"
                               <?php checked( $countdown_enable_semicolon ) ?>
                        />
                        <span class="label"><?php echo esc_html( $countdown_enable_semicolon ? esc_html__( 'Yes', 'bulletinwp' ) : esc_html__( 'No', 'bulletinwp' ) ) ?></span>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>
