<?php

defined( 'ABSPATH' ) or exit;

// Default values
isset( $content ) or $content               = '';
isset( $mobile_content ) or $mobile_content = '';

// Visible but disabled
isset( $is_multiple_messages ) or $is_multiple_messages     = false;
isset( $hide_fields_from_cycle ) or $hide_fields_from_cycle = false;
isset( $add_button ) or $add_button                         = false;
isset( $is_dismissable ) or $is_dismissable                 = false;

if ( bulletinwp_fs()->is__premium_only() ) {
  // Actual hidden on premium
  isset( $messages ) or $messages = [
      [
          'content'        => '',
          'mobile_content' => '',
      ],
  ];

  isset( $cookie_expiry ) or $cookie_expiry                                 = '';
  isset( $rotation_style ) or $rotation_style                               = 'cycle';
  isset( $cycle_speed ) or $cycle_speed                                     = '';
  isset( $marquee_speed ) or $marquee_speed                                 = '';
  isset( $button_label ) or $button_label                                   = '';
  isset( $button_mobile_label ) or $button_mobile_label                     = '';
  isset( $button_background_color ) or $button_background_color             = '#ffffff';
  isset( $button_font_color ) or $button_font_color                         = '#000000';
  isset( $button_hover_background_color ) or $button_hover_background_color = '';
  isset( $button_hover_font_color ) or $button_hover_font_color             = '';
  isset( $button_action ) or $button_action                                 = 'link';
  isset( $button_cookie_expiry ) or $button_cookie_expiry                   = '';
  isset( $button_link ) or $button_link                                     = '';
  isset( $button_target ) or $button_target                                 = 'same-tab';
  isset( $button_align ) or $button_align                                   = 'content';
  isset( $button_js_event ) or $button_js_event                             = '';
  isset( $button_easy_popup ) or $button_easy_popup                         = '';
  isset( $button_attention_effect ) or $button_attention_effect             = 'default';

  if ( BULLETINWP::instance()->pro->maybe_easy_popups_plugin_is_activated() ) {
    $popups             = EASY_POPUPS::instance()->sql->get_all_active_popups_ignore_visibility();
    $easy_popup_options = [];

    if ( ! empty( $popups ) ) {
      foreach ( $popups as $popup ) {
        $popup_id    = $popup['id'];
        $popup_title = ( isset( $popup['popup_title'] ) && ! empty( $popup['popup_title'] ) ) ? $popup['popup_title'] : '';

        $easy_popup_options[] = [
            'value' => $popup_id,
            'label' => $popup_title,
        ];
      }
    }
  }

  $button_attention_effect_options = [
    [
      'value' => 'default',
      'label' => esc_html__( 'None', 'bulletinwp' ),
    ],
    [
      'value' => 'flash',
      'label' => esc_html__( 'Flash', 'bulletinwp' ),
    ],
    [
      'value' => 'shake',
      'label' => esc_html__( 'Shake', 'bulletinwp' ),
    ],
    [
      'value' => 'swing',
      'label' => esc_html__( 'Swing', 'bulletinwp' ),
    ],
    [
      'value' => 'tada',
      'label' => esc_html__( 'Tada', 'bulletinwp' ),
    ],
    [
      'value' => 'heartbeat',
      'label' => esc_html__( 'Heartbeat', 'bulletinwp' ),
    ],
    [
      'value' => 'wobble',
      'label' => esc_html__( 'Wobble', 'bulletinwp' ),
    ],
  ];
}

// Images directory
$images_dir = plugin_dir_url( BULLETINWP__FILE__ ) . 'admin/images';

?>

<!-- TAB - Message -->
<div id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-message-tab' ) ?>" class="tab-pane active">
  <div class="flex items-center mb-8 md:mb-12">
    <div class="heading-icon mr-4">
      <img src="<?php echo esc_url( $images_dir . '/tab-icon/message.svg' ) ?>" alt="">
    </div>

    <div class="tab-heading">
      <?php esc_html_e( 'Message', 'bulletinwp' ) ?>
    </div>
  </div>

  <div class="flex items-end justify-between">
    <div class="heading">
      <?php esc_html_e( 'Message', 'bulletinwp' ) ?>
    </div>

    <div class="text-right modal-button-wrapper relative" data-overlay=".modal-overlay" data-id-modal="#support-markdown-modal">
      <a class="modal-button cursor-pointer"><?php esc_html_e( 'supports markdown, emojis & links', 'bulletinwp' ) ?></a>

      <div id="support-markdown-modal" class="modal opacity-0 pointer-events-none relative">
        <div class="modal-overlay tooltip-overlay"></div>

        <div class="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-support-markdown box-container' ) ?>">
          <div class="line-indicator"></div>

          <div class="flex my-4 border-b-2">
            <div class="w-1/2 px-4">
              <div class="heading"><?php esc_html_e( 'Enter this', 'bulletinwp' ); ?></div>
            </div>
            <div class="w-1/2 px-4">
              <div class="heading"><?php esc_html_e( 'To see this', 'bulletinwp' ); ?></div>
            </div>
          </div>

          <div class="flex my-4">
            <div class="w-1/2 px-4">
              <p class="font-couriernew">
                **<?php esc_html_e( 'This is bold', 'bulletinwp' ); ?>**
              </p>
            </div>
            <div class="w-1/2 px-4">
              <div class="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-markdown-items' ) ?>">
                **<?php esc_html_e( 'This is bold', 'bulletinwp' ); ?>**
              </div>
            </div>
          </div>

          <div class="flex my-4">
            <div class="w-1/2 px-4">
              <p class="font-couriernew">
                  *<?php esc_html_e( 'This is italic', 'bulletinwp' ); ?>*
              </p>
            </div>
            <div class="w-1/2 px-4">
              <div class="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-markdown-items' ) ?>">
                  *<?php esc_html_e( 'This is italic', 'bulletinwp' ); ?>*
              </div>
            </div>
          </div>

          <div class="flex my-4">
            <div class="w-1/2 px-4">
              <p class="font-couriernew">
                  [<?php esc_html_e( 'link text', 'bulletinwp' ); ?>](https://google.com)
              </p>
            </div>
            <div class="w-1/2 px-4">
              <div class="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-markdown-items' ) ?>">
                [<?php esc_html_e( 'link text', 'bulletinwp' ); ?>](https://google.com)
              </div>
            </div>
          </div>

          <div class="flex my-4">
            <div class="w-1/2 px-4">
              <p class="font-couriernew">
                <?php echo esc_html( htmlspecialchars( '<a href="https://google.com" target="_blank">' ) ); ?>
                <?php esc_html_e( 'link text', 'bulletinwp' ); ?> (<?php esc_html_e( 'open in new tab', 'bulletinwp' ); ?>)
                <?php echo esc_html( htmlspecialchars( '</a>' ) ); ?>
              </p>
            </div>
            <div class="w-1/2 px-4">
              <div>
                <p>
                  <a href="https://google.com" target="_blank">
                    <?php esc_html_e( 'link text', 'bulletinwp' ); ?> (<?php esc_html_e( 'open in new tab', 'bulletinwp' ); ?>)
                  </a>
                </p>
              </div>
            </div>
          </div>

          <div class="flex my-4">
            <div class="w-1/2 px-4">
              <p class="font-couriernew">
                <?php esc_html_e( 'paste codes', 'bulletinwp' ); ?> `<?php esc_html_e( 'with backticks', 'bulletinwp' ); ?>`
              </p>
            </div>
            <div class="w-1/2 px-4">
              <div class="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-markdown-item' ) ?>">
                <?php esc_html_e( 'paste codes', 'bulletinwp' ); ?> `<?php esc_html_e( 'with backticks', 'bulletinwp' ); ?>`
              </div>
            </div>
          </div>

          <div class="flex my-4">
            <div class="w-1/2 px-4">
              <p class="font-couriernew">:grin:</p>
              <div class="text-left">
                <a href="https://gist.github.com/rxaviers/7360908" target="_blank">
                  <?php esc_html_e( 'view full list of emoji commands', 'bulletinwp' ); ?>
                </a>
              </div>
            </div>
            <div class="w-1/2 px-4">
              <div class="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-markdown-item' ) ?>">:grin:</div>
            </div>
          </div>

        </div>
      </div>
    </div>
  </div>

  <hr class="my-4">

  <div class="flex flex-wrap -mx-4">
    <div class="form-field form-field-text w-full lg:w-1/2 mb-4 lg:mb-0 px-4 is-required">
      <label class="mb-2" for="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-content' ) ?>">
        <?php esc_html_e( 'Tablet and up', 'bulletinwp' ) ?> <span class="text-red-200">*</span>
      </label>
      <textarea id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-content' ) ?>"
                class="form-input textarea-input w-full"
                type="text"
                name="content"
                placeholder=""
                required
      ><?php echo esc_textarea( $content ) ?></textarea>
    </div>

    <div class="form-field form-field-text w-full lg:w-1/2 mb-4 lg:mb-0 px-4">
      <label class="mb-2" for="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-mobile-content' ) ?>">
        <?php esc_html_e( 'Mobile only (optional)', 'bulletinwp' ) ?>
      </label>
      <textarea id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-mobile-content' ) ?>"
                class="form-input textarea-input w-full"
                type="text"
                name="mobileContent"
                placeholder=""
      ><?php echo esc_textarea( $mobile_content ) ?></textarea>
    </div>
  </div>

  <div class="mt-8">
    <div class="heading flex items-center">
      <?php esc_html_e( 'Add multiple messages', 'bulletinwp' ) ?>
      <?php if ( bulletinwp_fs()->is__premium_only() ) :
      else :?>
        <div class="pro-pill">PRO</div>
      <?php endif; ?>
    </div>

    <hr class="my-4">
      <!-- Toggle -->
      <div class="checkbox-wrapper toggle-switch <?php echo esc_attr( bulletinwp_fs()->is__premium_only() ? '' : 'pro-disabled' ) ?>"
          data-checked-label="<?php echo esc_attr( esc_html__( 'Yes', 'bulletinwp' ) ) ?>"
          data-unchecked-label="<?php echo esc_attr( esc_html__( 'No', 'bulletinwp' ) ) ?>"
          data-hide-show-elements="<?php echo esc_attr( '#' . BULLETINWP_PLUGIN_SLUG . '-messages-element, #' . BULLETINWP_PLUGIN_SLUG . '-rotation-style-element' ) ?>"
      >
        <input type="checkbox" name="isMultipleMessages" <?php checked( $is_multiple_messages ) ?> />
        <span class="label"><?php echo esc_html( $is_multiple_messages ? esc_html__( 'Yes', 'bulletinwp' ) : esc_html__( 'No', 'bulletinwp' ) ) ?></span>
      </div>

      <?php if ( bulletinwp_fs()->is__premium_only() ) : ?>
        <!-- Repeater Messages -->
        <div id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-messages-element' ) ?>"
            class="mt-4"
            style="display: <?php echo esc_attr( $is_multiple_messages ? 'block' : 'none' ) ?>;"
        >

          <?php if ( ! empty( $messages ) ) : ?>
            <div class="repeater-container">
              <?php foreach ( $messages as $key => $message ) : ?>
                <div class="repeater-item mb-4">
                  <!-- Message -->
                  <div class="message -mx-4">
                    <div class="form-field form-field-text w-1/2 px-4">
                      <label><?php esc_html_e( 'Tablet and up', 'bulletinwp' ) ?></label>
                      <textarea class="form-input textarea-input w-full"
                              type="text"
                              name="messageContent[]"
                              placeholder=""
                      ><?php echo esc_textarea( $message['content'] ) ?></textarea>
                    </div>

                    <div class="form-field form-field-text w-1/2 px-4">
                      <label><?php esc_html_e( 'Mobile only (optional)', 'bulletinwp' ) ?></label>
                      <textarea class="form-input textarea-input w-full"
                              type="text"
                              name="messageMobileContent[]"
                              placeholder=""
                      ><?php echo esc_textarea( $message['mobile_content'] ) ?></textarea>
                    </div>
                  </div>

                  <!-- Controls -->
                  <div class="controls">
                    <div class="control-button add-button mr-2" title="Add Item">
                        <div class="control-button-icon"></div>
                    </div>

                    <?php if ( $key !== 0 ) : ?>
                      <div class="control-button delete-button" title="Remove Item">
                        <div class="control-button-icon"></div>
                      </div>
                    <?php else : ?>
                      <div class="control-button placeholder-button">
                        <div class="control-button-icon"></div>
                      </div>
                    <?php endif; ?>
                  </div>
                </div>
              <?php endforeach; ?>

              <!-- For cloning more repeater fields -->
              <div class="repeater-item mb-4 cloner">
                <!-- Message -->
                <div class="message -mx-4">
                  <div class="form-field form-field-text w-1/2 px-4 is-required">
                    <label><?php esc_html_e( 'Tablet and up', 'bulletinwp' ) ?></label>
                    <textarea class="form-input textarea-input w-full"
                              type="text"
                              name="messageContent[]"
                              placeholder=""
                    ></textarea>
                  </div>

                  <div class="form-field form-field-text w-1/2 px-4">
                    <label><?php esc_html_e( 'Mobile only (optional)', 'bulletinwp' ) ?></label>
                    <textarea class="form-input textarea-input w-full"
                                type="text"
                                name="messageMobileContent[]"
                                placeholder=""
                    ></textarea>
                  </div>
                </div>

                <!-- Controls -->
                <div class="controls">
                  <div class="control-button add-button mr-2" title="Add Item">
                    <div class="control-button-icon"></div>
                  </div>

                  <div class="control-button delete-button" title="Remove Item">
                    <div class="control-button-icon"></div>
                  </div>
                </div>
              </div>
            </div>
          <?php endif; ?>

          <!-- Hide empty fields from cycle -->
          <div class="mt-4">
            <div class="mb-4"><?php esc_html_e( 'Hide empty fields from cycle', 'bulletinwp' ) ?></div>

            <div class="checkbox-wrapper toggle-switch"
                data-checked-label="<?php echo esc_attr( esc_html__( 'Yes', 'bulletinwp' ) ) ?>"
                data-unchecked-label="<?php echo esc_attr( esc_html__( 'No', 'bulletinwp' ) ) ?>"
            >
              <input type="checkbox" name="hideFieldsFromCycle" <?php checked( $hide_fields_from_cycle ) ?> />
              <span class="label"><?php echo esc_html( $hide_fields_from_cycle ? esc_html__( 'Yes', 'bulletinwp' ) : esc_html__( 'No', 'bulletinwp' ) ) ?></span>
            </div>
          </div>
        </div>

        <!-- Rotation -->
        <div id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-rotation-style-element' ) ?>"
            class="mt-4"
            style="display: <?php echo esc_attr( $is_multiple_messages ? 'block' : 'none' ) ?>;"
        >
          <div class="mb-4"><?php esc_html_e( 'Rotation style', 'bulletinwp' ) ?></div>

          <!-- Radio group -->
          <div class="radio-group-wrapper flex mb-4">
            <div class="mr-4">
              <label class="radio-wrapper">
                <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-rotation-style-cycle' ) ?>"
                      type="radio"
                      name="rotationStyle"
                      value="cycle"
                      data-show-elements="<?php echo esc_attr( '#' . BULLETINWP_PLUGIN_SLUG . '-cycle-speed-label' ) ?>"
                      <?php checked( $rotation_style === 'cycle' ) ?>
                />
                <span class="thumb"></span>
                <span><?php esc_html_e( 'Cycle through', 'bulletinwp' ) ?></span>
              </label>
            </div>

            <div>
              <label class="radio-wrapper">
                <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-rotation-style-marquee' ) ?>"
                        type="radio"
                        name="rotationStyle"
                        value="marquee"
                        data-show-elements="<?php echo esc_attr( '#' . BULLETINWP_PLUGIN_SLUG . '-marquee-speed-label' ) ?>"
                        <?php checked( $rotation_style === 'marquee' ) ?>
                />
                <span class="thumb"></span>
                <span><?php esc_html_e( 'Marquee style', 'bulletinwp' ) ?></span>
              </label>
            </div>
          </div>

          <!-- Speed option -->
          <div id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-marquee-speed-element' ) ?>"
              class="mb-4">
            <div class="flex flex-wrap -mx-4">
              <div class="w-full lg:w-auto mb-4 lg:mb-0 px-4">
                <div id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-cycle-speed-label' ) ?>"
                    style="display: <?php echo esc_attr( ( $rotation_style === 'cycle' ) ? 'block' : 'none' ); ?>">
                  <label for="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-cycle-speed' ) ?>"><?php esc_html_e( 'Cycle speed', 'bulletinwp' ) ?></label>
                  <span class="text-xs"><?php esc_html_e( '(in ms, leave blank for default cycle speed)', 'bulletinwp' ) ?></span>
                  <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-cycle-speed' ) ?>"
                          class="w-full"
                          type="number"
                          name="cycleSpeed"
                          value="<?php echo esc_attr( $cycle_speed ) ?>"
                          placeholder="3000"
                  />
                </div>

                <div id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-marquee-speed-label' ) ?>"
                    style="display: <?php echo esc_attr( ( $rotation_style === 'marquee' ) ? 'block' : 'none' ); ?>">
                  <label for="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-marquee-speed' ) ?>"><?php esc_html_e( 'Marquee speed', 'bulletinwp' ) ?></label>
                  <span class="text-xs"><?php esc_html_e( '(in ms, leave blank for default marquee speed)', 'bulletinwp' ) ?></span>
                  <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-marquee-speed' ) ?>"
                          class="w-full"
                          type="number"
                          name="marqueeSpeed"
                          value="<?php echo esc_attr( $marquee_speed ) ?>"
                          placeholder="50000"
                  />
                </div>
              </div>
            </div>
          </div>
        </div>
      <?php endif; ?>
  </div>

  <div class="mt-8">
      <div class="heading flex items-center">
        <?php esc_html_e( 'Add button', 'bulletinwp' ) ?>
        <?php if ( bulletinwp_fs()->is__premium_only() ) :
        else :?>
          <div class="pro-pill">PRO</div>
        <?php endif; ?>
      </div>

      <hr class="my-4">

      <div class="checkbox-wrapper toggle-switch <?php echo esc_attr( bulletinwp_fs()->is__premium_only() ? '' : 'pro-disabled' ) ?>"
          data-checked-label="<?php esc_html_e( 'Yes', 'bulletinwp' ) ?>"
          data-unchecked-label="<?php esc_html_e( 'No', 'bulletinwp' ) ?>"
          data-hide-show-elements="<?php echo esc_attr( '#' . BULLETINWP_PLUGIN_SLUG . '-button-elements' ) ?>"
      >
      <input type="checkbox" name="addButton" <?php checked( $add_button ) ?> />
      <span class="label"><?php echo esc_html( $add_button ? esc_html__( 'Yes', 'bulletinwp' ) : esc_html__( 'No', 'bulletinwp' ) ) ?></span>
      </div>

      <?php if ( bulletinwp_fs()->is__premium_only() ) : ?>
        <div id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-button-elements' ) ?>"
                class="mt-4"
                style="display: <?php echo esc_attr( $add_button ? 'block' : 'none' ) ?>;"
        >
          <div class="flex flex-wrap -mx-4 mb-4">
            <div class="form-field form-field-text w-full lg:w-1/2 mb-4 lg:mb-0 px-4 is-required">
                <label class="mb-2" for="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-button-label' ) ?>"><?php esc_html_e( 'Button label', 'bulletinwp' ) ?></label>
                <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-button-label' ) ?>"
                        class="form-input w-full"
                        type="text"
                        name="buttonLabel"
                        value="<?php echo esc_attr( $button_label ) ?>"
                        placeholder=""
                />
            </div>

            <div class="form-field form-field-text w-full lg:w-1/2 mb-4 lg:mb-0 px-4">
                <label class="mb-2" for="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-button-mobile-label' ) ?>"><?php esc_html_e( 'Button mobile label', 'bulletinwp' ) ?></label>
                <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-button-mobile-label' ) ?>"
                        class="form-input w-full"
                        type="text"
                        name="buttonMobileLabel"
                        value="<?php echo esc_attr( $button_mobile_label ) ?>"
                        placeholder=""
                />
            </div>
          </div>

          <div class="flex flex-wrap -mx-4">
            <div class="w-full xl:w-1/2 px-4">
              <div class="form-field form-field-color-picker flex flex-col mr-0 md:mr-4 mb-4 is-required">
                <label class="mb-2" for="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-button-background-color' ) ?>"><?php esc_html_e( 'Button Background color', 'bulletinwp' ) ?></label>
                <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-button-background-color' ) ?>"
                      class="form-input color-picker-input"
                      type="text"
                      name="buttonBackgroundColor"
                      value="<?php echo esc_attr( $button_background_color ) ?>"
                      placeholder=""
                      data-default-color=""
                />
              </div>
            </div>
            <div class="w-full xl:w-1/2 px-4">
                <div class="form-field form-field-color-picker flex flex-col mr-0 md:mr-4 mb-4 is-required">
                <label class="mb-2" for="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-button-font-color' ) ?>"><?php esc_html_e( 'Button Font color', 'bulletinwp' ) ?></label>
                <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-button-font-color' ) ?>"
                        class="form-input color-picker-input"
                        type="text"
                        name="buttonFontColor"
                        value="<?php echo esc_attr( $button_font_color ) ?>"
                        placeholder=""
                        data-default-color=""
                />
                </div>
            </div>
          </div>

          <div class="flex flex-wrap -mx-4">
            <div class="w-full xl:w-1/2 px-4">
                <div class="form-field form-field-color-picker flex flex-col mr-0 md:mr-4 mb-4">
                <label class="mb-2" for="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-button-hover-background-color' ) ?>"><?php esc_html_e( 'Button Hover background color', 'bulletinwp' ) ?></label>
                <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-button-hover-background-color' ) ?>"
                        class="form-input color-picker-input"
                        type="text"
                        name="buttonHoverBackgroundColor"
                        value="<?php echo esc_attr( ! empty( $button_hover_background_color ) ? $button_hover_background_color : $button_font_color ) ?>"
                        placeholder=""
                        data-default-color=""
                />
                </div>
            </div>

            <div class="w-full xl:w-1/2 px-4">
                <div class="form-field form-field-color-picker flex flex-col mr-0 md:mr-4 mb-4">
                <label class="mb-2" for="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-button-hover-font-color' ) ?>"><?php esc_html_e( 'Button Hover font color', 'bulletinwp' ) ?></label>
                <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-button-hover-font-color' ) ?>"
                        class="form-input color-picker-input"
                        type="text"
                        name="buttonHoverFontColor"
                        value="<?php echo esc_attr( ! empty( $button_hover_font_color ) ? $button_hover_font_color : $button_background_color ) ?>"
                        placeholder=""
                        data-default-color=""
                />
                </div>
            </div>
          </div>

          <div class="mb-2"><?php esc_html_e( 'Button action', 'bulletinwp' ) ?></div>

          <div class="radio-group-wrapper flex mb-4">
            <div class="mr-4">
                <label class="radio-wrapper">
                <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-button-action-link' ) ?>"
                        type="radio"
                        name="buttonAction"
                        value="link"
                        data-show-elements="<?php echo esc_attr( '#' . BULLETINWP_PLUGIN_SLUG . '-button-link-element, #' . BULLETINWP_PLUGIN_SLUG . '-button-target-element' ) ?>"
                        <?php checked( $button_action === 'link' ) ?>
                />
                <span class="thumb"></span>
                <span><?php esc_html_e( 'Link', 'bulletinwp' ) ?></span>
                </label>
            </div>

            <div class="mr-4">
                <label class="radio-wrapper">
                <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-button-action-custom-js-event' ) ?>"
                        type="radio"
                        name="buttonAction"
                        value="custom-js-event"
                        data-show-elements="<?php echo esc_attr( '#' . BULLETINWP_PLUGIN_SLUG . '-button-js-event-element' ) ?>"
                        <?php checked( $button_action === 'custom-js-event' ) ?>
                />
                <span class="thumb"></span>
                <span><?php esc_html_e( 'Custom JS Event', 'bulletinwp' ) ?></span>
                </label>
            </div>

            <div class="mr-4">
                <label class="radio-wrapper">
                <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-button-action-dismiss-bulletin' ) ?>"
                        type="radio"
                        name="buttonAction"
                        value="dismiss-bulletin"
                        data-show-elements="<?php echo esc_attr( '#' . BULLETINWP_PLUGIN_SLUG . '-button-cookie-expiry-element' ) ?>"
                        <?php checked( $button_action === 'dismiss-bulletin' ) ?>
                />
                <span class="thumb"></span>
                <span><?php esc_html_e( 'Dismiss Bulletin', 'bulletinwp' ) ?></span>
                </label>
            </div>

            <?php if ( BULLETINWP::instance()->pro->maybe_easy_popups_plugin_is_activated() ) : ?>
                <div>
                <label class="radio-wrapper">
                    <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-button-action-trigger-easy-popup' ) ?>"
                            type="radio"
                            name="buttonAction"
                            value="trigger-easy-popup"
                            data-show-elements="<?php echo esc_attr( '#' . BULLETINWP_PLUGIN_SLUG . '-button-easy-popup-element' ) ?>"
                            <?php checked( $button_action === 'trigger-easy-popup' ) ?>
                    />
                    <span class="thumb"></span>
                    <span><?php esc_html_e( 'Trigger Easy Popup', 'bulletinwp' ) ?></span>
                </label>
                </div>
            <?php endif; ?>
          </div>

          <div id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-button-link-element' ) ?>"
            class="form-field form-field-text mb-4 is-required"
            style="display: <?php echo esc_attr( $button_action === 'link' ? 'block' : 'none' ); ?>;"
            >
            <label class="mb-2" for="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-button-link' ) ?>"><?php esc_html_e( 'Button link', 'bulletinwp' ) ?></label>
            <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-button-link' ) ?>"
                    class="form-input w-full"
                    type="text"
                    name="buttonLink"
                    value="<?php echo esc_attr( $button_link ) ?>"
                    placeholder="https://example.com"
            />
          </div>

          <div id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-button-target-element' ) ?>"
              class="mb-4"
              style="display: <?php echo esc_attr( $button_action === 'link' ? 'block' : 'none' ); ?>;"
            >
            <div class="mb-2"><?php esc_html_e( 'Button target', 'bulletinwp' ) ?></div>

            <div class="radio-group-wrapper flex">

                <div class="mr-4">
                <label class="radio-wrapper">
                    <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-button-target-same-tab' ) ?>"
                            type="radio"
                            name="buttonTarget"
                            value="same-tab"
                            <?php checked( $button_target === 'same-tab' ) ?>
                    />
                    <span class="thumb"></span>
                    <span><?php esc_html_e( 'Same tab', 'bulletinwp' ) ?></span>
                </label>
                </div>
                <div>
                <label class="radio-wrapper">
                    <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-button-target-new-tab' ) ?>"
                            type="radio"
                            name="buttonTarget"
                            value="new-tab"
                            <?php checked( $button_target === 'new-tab' ) ?>
                    />
                    <span class="thumb"></span>
                    <span><?php esc_html_e( 'New tab', 'bulletinwp' ) ?></span>
                </label>
                </div>
            </div>
          </div>

          <div id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-button-js-event-element' ) ?>"
              class="form-field form-field-text mb-4 is-required"
              style="display: <?php echo esc_attr( $button_action === 'custom-js-event' ? 'block' : 'none' ); ?>;">
            <label class="mb-2" for="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-button-js-event' ) ?>"><?php esc_html_e( 'Button JS Event', 'bulletinwp' ) ?></label>
            <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-button-js-event' ) ?>"
                    class="form-input w-full"
                    type="text"
                    name="buttonJSEvent"
                    value="<?php echo esc_attr( $button_js_event ) ?>"
                    placeholder="ShowMyModal();"
            />
          </div>

          <div id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-button-cookie-expiry-element' ) ?>"
              class="form-field form-field-text mb-4 is-required"
              style="display: <?php echo esc_attr( $button_action === 'dismiss-bulletin' ? 'block' : 'none' ); ?>;">
            <label class="mb-2" for="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . 'button-cookie-expiry' ) ?>"><?php esc_html_e( 'Cookie expiry (in hours). Use -1 to dismiss forever', 'bulletinwp' ) ?></label>
            <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . 'button-cookie-expiry' ) ?>"
                  class="form-input w-full"
                  type="number"
                  name="buttonCookieExpiry"
                  value="<?php echo esc_attr( $button_cookie_expiry ) ?>"
                  placeholder=""
            />
          </div>

          <?php if ( BULLETINWP::instance()->pro->maybe_easy_popups_plugin_is_activated() ) : ?>
            <div id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-button-easy-popup-element' ) ?>"
                class="form-field form-field-select easy-popups-select-wrapper mb-4 is-required"
                style="display: <?php echo esc_attr( $button_action === 'trigger-easy-popup' ? 'block' : 'none' ); ?>">
                <div><?php esc_html_e( 'Select easy popup', 'bulletinwp' ) ?></div>

                <select id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-select-easy-popup' ) ?>"
                        class="form-input select2 infinity easy-popup-select"
                        name="buttonEasyPopup"
                >
                <option value="" <?php echo selected( $button_easy_popup === '' ) ?>>
                    <?php esc_html_e( 'Select easy popup', 'bulletinwp' ) ?>
                </option>

                <?php foreach ( $easy_popup_options as $option ) : ?>
                    <option value="<?php echo esc_attr( $option['value'] ) ?>"
                    <?php echo selected( $button_easy_popup === $option['value'] ); ?>
                    >
                    <?php echo esc_html( $option['label'] ) ?>
                    </option>
                <?php endforeach; ?>
                </select>
            </div>
          <?php endif; ?>

          <div id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-button-align-element' ) ?>" class="mb-4">
            <div class="mb-2"><?php esc_html_e( 'Button alignment', 'bulletinwp' ) ?></div>
            <div class="radio-group-wrapper flex">
                <div class="mr-4">
                <label class="radio-wrapper">
                    <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-button-align-content' ) ?>"
                            type="radio"
                            name="buttonAlign"
                            value="content"
                            <?php checked( $button_align === 'content' ) ?>
                    />
                    <span class="thumb"></span>
                    <span><?php esc_html_e( 'Aligned with content', 'bulletinwp' ) ?></span>
                </label>
                </div>

                <div>
                <label class="radio-wrapper">
                    <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-button-align-right' ) ?>"
                            type="radio"
                            name="buttonAlign"
                            value="right"
                            <?php checked( $button_align === 'right' ) ?>
                    />
                    <span class="thumb"></span>
                    <span><?php esc_html_e( 'Align right', 'bulletinwp' ) ?></span>
                </label>
                </div>
            </div>
          </div>

          <div id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-button-attention-effect-element' ) ?>">
            <div class="mb-2"><?php esc_html_e( 'Button Attention Effect', 'bulletinwp' ) ?></div>
            <div class="form-field form-field-select button-attention-effect-select-wrapper">
              <select class="form-input select2 button-attention-effect-select" name="buttonAttentionEffect">
                  <?php foreach ( $button_attention_effect_options as $option ) : ?>
                    <option value="<?php echo esc_attr( $option['value'] ) ?>"
                      <?php echo selected( $button_attention_effect === $option['value'] ); ?>
                    >
                      <?php echo esc_html( $option['label'] ) ?>
                    </option>
                  <?php endforeach; ?>
              </select>
            </div>
          </div>
        </div>
      <?php endif; ?>
  </div>

  <!-- Allow user to dismiss -->
  <div class="mt-8">
      <div class="heading flex items-center">
      <?php esc_html_e( 'Allow user to dismiss bulletin?', 'bulletinwp' ) ?>

      <?php if ( bulletinwp_fs()->is__premium_only() ) :
      else :?>
          <div class="pro-pill">PRO</div>
      <?php endif; ?>
      </div>

      <hr class="my-4">

      <div class="checkbox-wrapper toggle-switch <?php echo esc_attr( bulletinwp_fs()->is__premium_only() ? '' : 'pro-disabled' ) ?>"
          data-checked-label="<?php esc_html_e( 'Yes', 'bulletinwp' ) ?>"
          data-unchecked-label="<?php esc_html_e( 'No', 'bulletinwp' ) ?>"

          data-hide-show-elements="<?php echo esc_attr( '#' . BULLETINWP_PLUGIN_SLUG . '-cookie-expiry-element' ) ?>"
      >
      <input type="checkbox" name="isDismissable" <?php checked( $is_dismissable ) ?> />
      <span class="label"><?php echo esc_html( $is_dismissable ? esc_html__( 'Yes', 'bulletinwp' ) : esc_html__( 'No', 'bulletinwp' ) ) ?></span>
      </div>

      <?php if ( bulletinwp_fs()->is__premium_only() ) : ?>
      <div id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-cookie-expiry-element' ) ?>"
              class="form-field form-field-text mt-4 is-required"
              style="display: <?php echo esc_attr( $is_dismissable ? 'block' : 'none' ) ?>;"
      >
          <label class="mb-2" for="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-cookie-expiry' ) ?>"><?php esc_html_e( 'Cookie expiry (in hours). Use -1 to dismiss forever', 'bulletinwp' ) ?></label>
          <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-cookie-expiry' ) ?>"
                  class="form-input w-full"
                  type="number"
                  name="cookieExpiry"
                  value="<?php echo esc_attr( $cookie_expiry ) ?>"
                  placeholder=""
          />
      </div>
      <?php endif; ?>
  </div>

</div>
