<?php

defined( 'ABSPATH' ) or exit;

include_once( BULLETINWP_PLUGIN_PATH . 'admin/views/common/constants/country-options.php' );

// Default values

// Visible but disabled
isset( $placement_by_content ) or $placement_by_content = 'everywhere';
isset( $placement_by_user ) or $placement_by_user       = 'everyone';

if ( bulletinwp_fs()->is__premium_only() ) {
    // Actual hidden on premium
    isset( $placement_selected_content_include ) or $placement_selected_content_include = [];
    isset( $placement_selected_content_exclude ) or $placement_selected_content_exclude = [];
    isset( $placement_user_cookie_value ) or $placement_user_cookie_value               = '';
    isset( $placement_user_ip_value ) or $placement_user_ip_value                       = '';
    isset( $placement_user_location_value ) or $placement_user_location_value           = '';
}

// Images directory
$images_dir = plugin_dir_url( BULLETINWP__FILE__ ) . 'admin/images';

?>

<!-- TAB - Placement -->
<div id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-placement-tab' ) ?>" class="tab-pane">
    <div class="flex items-center mb-8 md:mb-12">
        <div class="heading-icon mr-4">
            <img src="<?php echo esc_url( $images_dir . '/tab-icon/message.svg' ) ?>" alt="">
        </div>

        <div class="tab-heading">
            <?php esc_html_e( 'Placement', 'bulletinwp' ) ?>
        </div>
    </div>

    <!-- Actual Pro Feat -->
    <div class="heading flex items-center">
        <?php esc_html_e( 'By content', 'bulletinwp' ) ?>

        <?php if ( bulletinwp_fs()->is__premium_only() ) :
        else :?>
            <div class="pro-pill">PRO</div>
        <?php endif; ?>
    </div>

    <hr class="my-4">

    <div class="radio-group-wrapper flex <?php echo esc_attr( bulletinwp_fs()->is__premium_only() ? '' : 'pro-disabled' ) ?>">
        <div class="mr-4">
            <label class="radio-wrapper">
                <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-placement-by-content-everywhere' ) ?>"
                        type="radio"
                        name="placementByContent"
                        value="everywhere"
                        <?php checked( $placement_by_content === 'everywhere' ) ?>
                />
                <span class="thumb"></span>
                <span><?php esc_html_e( 'Show everywhere', 'bulletinwp' ) ?></span>
            </label>
        </div>

        <div>
            <label class="radio-wrapper">
                <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-placement-by-content-selected-content' ) ?>"
                        type="radio"
                        name="placementByContent"
                        value="selected-content"
                        data-show-elements="<?php echo esc_attr( '#' . BULLETINWP_PLUGIN_SLUG . '-placement-selected-content-include-element' ) ?>, #<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-placement-selected-content-exclude-element' ) ?>"
                        <?php checked( $placement_by_content === 'selected-content' ) ?>
                />
                <span class="thumb"></span>
                <span><?php esc_html_e( 'Show only on certain content', 'bulletinwp' ) ?></span>
            </label>
        </div>
    </div>

    <?php if ( bulletinwp_fs()->is__premium_only() ) : ?>
        <!-- Include -->
        <div id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-placement-selected-content-include-element' ) ?>"
            class="mt-4"
            style="display: <?php echo esc_attr( ( $placement_by_content === 'selected-content' ? 'block' : 'none' ) ); ?>;"
        >
            <label for="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-placement-selected-content-include' ) ?>">
                <strong><?php esc_html_e( 'Include', 'bulletinwp' ) ?></strong> <?php esc_html_e( 'this bulletin on the following pages or posts (one per line, leave empty to include everywhere)', 'bulletinwp' ) ?>
            </label>

            <div>
                <textarea id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-placement-selected-content-include' ) ?>"
                        class="form-input textarea-input w-full"
                        name="placementSelectedContentInclude"
                        placeholder="/products/(.*)"
                ><?php echo esc_textarea( is_array( $placement_selected_content_include ) ? implode( "\n", $placement_selected_content_include ) : '' ); ?></textarea>
            </div>

            <div class="text-sm">
                <i><?php esc_html_e( 'The domain part of the URL will be stripped automatically.', 'bulletinwp' ) ?></i>
                <br />
                <i><?php esc_html_e( 'Use (.*) wildcards to address multiple URLs under a given path.', 'bulletinwp' ) ?></i>
            </div>
        </div>

        <!-- Exclude -->
        <div id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-placement-selected-content-exclude-element' ) ?>"
            class="mt-4"
            style="display: <?php echo esc_attr( $placement_by_content === 'selected-content' ? 'block' : 'none' ); ?>;"
        >
            <label for="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-placement-selected-content-exclude' ) ?>">
                <strong><?php esc_html_e( 'Exclude', 'bulletinwp' ) ?></strong> <?php esc_html_e( 'this bulletin on the following pages or posts (one per line, leave empty to exclude nowhere)', 'bulletinwp' ) ?>
            </label>

            <div>
                <textarea id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-placement-selected-content-exclude' ) ?>"
                        class="form-input textarea-input w-full"
                        name="placementSelectedContentExclude"
                        placeholder="/products/(.*)"
                ><?php echo esc_textarea( is_array( $placement_selected_content_exclude ) ? implode( "\n", $placement_selected_content_exclude ) : '' ); ?></textarea>
            </div>

            <div class="text-sm">
                <i><?php esc_html_e( 'The domain part of the URL will be stripped automatically.', 'bulletinwp' ) ?></i>
                <br />
                <i><?php esc_html_e( 'Use (.*) wildcards to address multiple URLs under a given path.', 'bulletinwp' ) ?></i>
            </div>
        </div>
    <?php endif; ?>

    <div class="mt-8">
        <div class="heading flex items-center">
            <?php esc_html_e( 'By user', 'bulletinwp' ) ?>

            <?php if ( bulletinwp_fs()->is__premium_only() ) :
            else :?>
                <div class="pro-pill">PRO</div>
            <?php endif; ?>
        </div>

        <hr class="my-4">

        <div class="radio-group-wrapper flex flex-wrap -mx-2 <?php echo esc_attr( bulletinwp_fs()->is__premium_only() ? '' : 'pro-disabled' ) ?>">
            <div class="px-2 mb-4">
                <label class="radio-wrapper">
                <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-placement-by-user-everyone' ) ?>"
                        type="radio"
                        name="placementByUser"
                        value="everyone"
                        <?php checked( $placement_by_user === 'everyone' ) ?>
                />
                <span class="thumb"></span>
                <span><?php esc_html_e( 'Show for everyone', 'bulletinwp' ) ?></span>
                </label>
            </div>

            <div class="px-2 mb-4">
                <label class="radio-wrapper">
                <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-placement-by-user-logged-in-users' ) ?>"
                        type="radio"
                        name="placementByUser"
                        value="logged-in-users"
                        <?php checked( $placement_by_user === 'logged-in-users' ) ?>
                />
                <span class="thumb"></span>
                <span><?php esc_html_e( 'Only logged-in users', 'bulletinwp' ) ?></span>
                </label>
            </div>

            <div class="px-2 mb-4">
                <label class="radio-wrapper">
                <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-placement-by-user-logged-out-users' ) ?>"
                        type="radio"
                        name="placementByUser"
                        value="logged-out-users"
                        <?php checked( $placement_by_user === 'logged-out-users' ) ?>
                />
                <span class="thumb"></span>
                <span><?php esc_html_e( 'Only logged-out users', 'bulletinwp' ) ?></span>
                </label>
            </div>

            <div class="px-2 mb-4">
                <label class="radio-wrapper">
                <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-placement-by-user-cookie-value' ) ?>"
                        type="radio"
                        name="placementByUser"
                        value="cookie-value"
                        data-show-elements="<?php echo esc_attr( '#' . BULLETINWP_PLUGIN_SLUG . '-placement-user-cookie-value-element' ) ?>"
                        <?php checked( $placement_by_user === 'cookie-value' ) ?>
                />
                <span class="thumb"></span>
                <span><?php esc_html_e( 'Based on cookie value', 'bulletinwp' ) ?></span>
                </label>
            </div>

            <div class="px-2 mb-4">
                <label class="radio-wrapper">
                <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-placement-by-user-ip-address' ) ?>"
                        type="radio"
                        name="placementByUser"
                        value="ip-address"
                        data-show-elements="<?php echo esc_attr( '#' . BULLETINWP_PLUGIN_SLUG . '-placement-user-ip-address-element' ) ?>"
                        <?php checked( $placement_by_user === 'ip-address' ) ?>
                />
                <span class="thumb"></span>
                <span><?php esc_html_e( 'Based on IP address', 'bulletinwp' ) ?></span>
                </label>
            </div>

            <div class="px-2 mb-4">
                <label class="radio-wrapper">
                <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-placement-by-user-location' ) ?>"
                        type="radio"
                        name="placementByUser"
                        value="geolocation"
                        data-show-elements="<?php echo esc_attr( '#' . BULLETINWP_PLUGIN_SLUG . '-placement-user-location-element' ) ?>"
                        <?php checked( $placement_by_user === 'geolocation' ) ?>
                />
                <span class="thumb"></span>
                <span><?php esc_html_e( 'Based on location', 'bulletinwp' ) ?></span>
                </label>
            </div>
        </div>

        <?php if ( bulletinwp_fs()->is__premium_only() ) : ?>
            <!-- Cookie value -->
            <div id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-placement-user-cookie-value-element' ) ?>"
                class="form-field form-field-text mt-4 is-required"
                style="display: <?php echo esc_attr( $placement_by_user === 'cookie-value' ? 'block' : 'none' ); ?>;"
            >
                <label for="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-placement-user-cookie-value' ) ?>"><?php esc_html_e( 'User cookie value', 'bulletinwp' ) ?></label>
                <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-placement-user-cookie-value' ) ?>"
                    class="form-input w-full"
                    type="text"
                    name="placementUserCookieValue"
                    value="<?php echo esc_attr( $placement_user_cookie_value ) ?>"
                />

                <div class="text-sm">
                    <i><?php esc_html_e( 'Enter the key of the cookie. If this is set on the browser, the bulletin will show.', 'bulletinwp' ) ?></i>
                </div>
            </div>

            <!-- IP Address -->
            <div id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-placement-user-ip-address-element' ) ?>"
                class="form-field form-field-text mt-4 is-required"
                style="display: <?php echo esc_attr( $placement_by_user === 'ip-address' ? 'block' : 'none' ); ?>;"
            >
                <label for="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-placement-user-ip-value' ) ?>"><?php esc_html_e( 'User IP address value', 'bulletinwp' ) ?></label>
                <input id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-placement-user-ip-value' ) ?>"
                    class="form-input w-full"
                    type="text"
                    name="placementUserIpValue"
                    value="<?php echo esc_attr( $placement_user_ip_value ) ?>"
                    placeholder="127.0.0.1, 192.168.0.1"
                />
                <div class="text-sm">
                    <i><?php esc_html_e( 'Enter the IP address of the users you want to show the banner to. (IPs separated by comma)', 'bulletinwp' ) ?></i>
                </div>
            </div>


            <!-- Geolocation -->
            <div id="<?php echo esc_attr( BULLETINWP_PLUGIN_SLUG . '-placement-user-location-element' ) ?>"
                class="form-field form-field-select mt-4 is-required"
                style="display: <?php echo esc_attr( $placement_by_user === 'geolocation' ? 'block' : 'none' ); ?>;"
            >
                <div class="mb-2"><?php esc_html_e( 'User location value', 'bulletinwp' ) ?></div>
                <select name="placementUserLocationValue" class="form-input select2">
                    <option value="" <?php echo selected( $placement_user_location_value === '' ) ?> >
                    <?php esc_html_e( 'Select Location', 'bulletinwp' ) ?>
                    </option>

                    <?php foreach ( $country_options as $country ) : ?>
                        <option value="<?php echo esc_attr( $country['code'] ) ?>"
                            <?php echo selected( $placement_user_location_value === $country['code'] ) ?>
                        >
                            <?php echo esc_html( $country['name'] ) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
        <?php endif; ?>
    </div>

</div>
