// MAIN
import main from './main';

// FEATURES
import dismiss from './features/pro/dismiss';
import multipleMessages from './features/pro/multipleMessages';
import countdown from './features/pro/countdown';
import placementLocation from './features/pro/placementLocation';
import message from './features/pro/message';

// STYLES
import '../styles/pro.scss';

jQuery(document).ready(function ($) {
  const bulletinwpBulletins = $(`.${window.BULLETINWP['pluginSlug']}-bulletins`);
  // Run before main()
  if (bulletinwpBulletins.length) {
    placementLocation(bulletinwpBulletins);
  }

  // MAIN
  main();

  // Run after main()
  if (bulletinwpBulletins.length) {
    // FEATURES
    // Countdown
    countdown(bulletinwpBulletins);
    // Dismiss
    dismiss(bulletinwpBulletins);
    // Multiple messages
    multipleMessages(bulletinwpBulletins);
    // Message
    message(bulletinwpBulletins);
  }
});
